/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion;

import cofh.core.CoFHProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.ConfigHandler;
import cofh.lib.util.helpers.StringHelper;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cofh.thermalexpansion.block.TEBlocks;
import cofh.thermalexpansion.block.cell.BlockCell;
import cofh.thermalexpansion.block.cell.TileCell;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.block.strongbox.TileStrongbox;
import cofh.thermalexpansion.block.workbench.TileWorkbench;
import cofh.thermalexpansion.core.Proxy;
import cofh.thermalexpansion.core.TEAchievements;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.core.TeleportChannelRegistry;
import cofh.thermalexpansion.gui.GuiHandler;
import cofh.thermalexpansion.gui.TECreativeTab;
import cofh.thermalexpansion.item.ItemSatchel;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.network.PacketTEBase;
import cofh.thermalexpansion.plugins.TEPlugins;
import cofh.thermalexpansion.plugins.nei.handlers.NEIRecipeWrapper;
import cofh.thermalexpansion.util.FMLEventHandler;
import cofh.thermalexpansion.util.FuelManager;
import cofh.thermalexpansion.util.IMCHandler;
import cofh.thermalexpansion.util.crafting.ChargerManager;
import cofh.thermalexpansion.util.crafting.CrucibleManager;
import cofh.thermalexpansion.util.crafting.ExtruderManager;
import cofh.thermalexpansion.util.crafting.FurnaceManager;
import cofh.thermalexpansion.util.crafting.InsolatorManager;
import cofh.thermalexpansion.util.crafting.PrecipitatorManager;
import cofh.thermalexpansion.util.crafting.PulverizerManager;
import cofh.thermalexpansion.util.crafting.RecipeMachine;
import cofh.thermalexpansion.util.crafting.RecipeMachineUpgrade;
import cofh.thermalexpansion.util.crafting.RecipeStyle;
import cofh.thermalexpansion.util.crafting.SawmillManager;
import cofh.thermalexpansion.util.crafting.SmelterManager;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cofh.thermalexpansion.util.crafting.TECraftingParser;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ThermalExpansion", name="Thermal Expansion", version="1.7.10R4.1.5", dependencies="required-after:CoFHCore@[1.7.10R3.1.4,1.7.10R3.2.0);required-after:ThermalFoundation@[1.7.10R1.2.6,1.7.10R1.3.0);", guiFactory="cofh.thermalexpansion.gui.GuiConfigTEFactory", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class ThermalExpansion
extends BaseMod {
    public static final String modId = "ThermalExpansion";
    public static final String modName = "Thermal Expansion";
    public static final String version = "1.7.10R4.1.5";
    public static final String version_max = "1.7.10R4.2.0";
    public static final String dependencies = "required-after:CoFHCore@[1.7.10R3.1.4,1.7.10R3.2.0);required-after:ThermalFoundation@[1.7.10R1.2.6,1.7.10R1.3.0);";
    public static final String modGuiFactory = "cofh.thermalexpansion.gui.GuiConfigTEFactory";
    public static final String version_group = "required-after:ThermalExpansion@[1.7.10R4.1.5,1.7.10R4.2.0);";
    public static final String releaseURL = "https://raw.github.com/CoFH/VERSION/master/ThermalExpansion";
    @Mod.Instance(value="ThermalExpansion")
    public static ThermalExpansion instance;
    @SidedProxy(clientSide="cofh.thermalexpansion.core.ProxyClient", serverSide="cofh.thermalexpansion.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final ConfigHandler configClient;
    public static final GuiHandler guiHandler;
    public static CreativeTabs tabCommon;
    public static CreativeTabs tabBlocks;
    public static CreativeTabs tabItems;
    public static CreativeTabs tabTools;
    public static CreativeTabs tabFlorbs;

    public ThermalExpansion() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent var1) {
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this, releaseURL, "http://teamcofh.com/downloads/"));
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/thermalexpansion/common.cfg"), true));
        configClient.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/thermalexpansion/client.cfg"), true));
        FMLEventHandler.initialize();
        TECraftingHandler.initialize();
        TECraftingParser.initialize();
        RecipeSorter.register((String)"thermalexpansion:machine", RecipeMachine.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofh:upgrade");
        RecipeSorter.register((String)"thermalexpansion:machineUpgrade", RecipeMachineUpgrade.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofh:upgrade");
        RecipeSorter.register((String)"thermalexpansion:style", RecipeStyle.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"thermalexpansion:NEIWrapper", NEIRecipeWrapper.class, (RecipeSorter.Category)RecipeSorter.Category.UNKNOWN, (String)"after:forge:shapedore");
        this.cleanConfig(true);
        this.configOptions();
        TEItems.preInit();
        TEBlocks.preInit();
        TEPlugins.preInit();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent var1) {
        this.registerMachineOreDict();
        TEItems.initialize();
        TEBlocks.initialize();
        TEPlugins.initialize();
        TeleportChannelRegistry.initialize();
        if (TEProps.enableAchievements) {
            TEAchievements.initialize();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        PacketTEBase.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent var1) {
        try {
            TECraftingParser.parseCraftingFiles();
        }
        catch (Throwable var3) {
            var3.printStackTrace();
        }
        FurnaceManager.addDefaultRecipes();
        PulverizerManager.addDefaultRecipes();
        SawmillManager.addDefaultRecipes();
        SmelterManager.addDefaultRecipes();
        CrucibleManager.addDefaultRecipes();
        TransposerManager.addDefaultRecipes();
        PrecipitatorManager.addDefaultRecipes();
        ExtruderManager.addDefaultRecipes();
        ChargerManager.addDefaultRecipes();
        InsolatorManager.addDefaultRecipes();
        TEItems.postInit();
        TEBlocks.postInit();
        TEPlugins.postInit();
        proxy.registerEntities();
        proxy.registerRenderInformation();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent var1) {
        IMCHandler.instance.handleIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)((Object)this)));
        TECraftingHandler.loadRecipes();
        FurnaceManager.loadRecipes();
        PulverizerManager.loadRecipes();
        SawmillManager.loadRecipes();
        SmelterManager.loadRecipes();
        CrucibleManager.loadRecipes();
        TransposerManager.loadRecipes();
        PrecipitatorManager.loadRecipes();
        ExtruderManager.loadRecipes();
        ChargerManager.loadRecipes();
        InsolatorManager.loadRecipes();
        FuelManager.parseFuels();
        TEPlugins.loadComplete();
        this.cleanConfig(false);
        config.cleanUp(false, true);
        configClient.cleanUp(false, true);
        log.info("Thermal Expansion: Load Complete.");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerAboutToStartEvent var1) {
        TeleportChannelRegistry.createServerRegistry();
        TeleportChannelRegistry.createClientRegistry();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartedEvent var1) {
        this.handleIdMapping();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent var1) {
        IMCHandler.instance.handleIMC((List<FMLInterModComms.IMCMessage>)var1.getMessages());
    }

    public void handleConfigSync(PacketCoFHBase var1) {
        this.handleIdMapping();
        for (int var2 = 0; var2 < TileDeviceBase.enableSecurity.length; ++var2) {
            TileDeviceBase.enableSecurity[var2] = var1.getBool();
        }
        for (int var3 = 0; var3 < TileMachineBase.enableSecurity.length; ++var3) {
            TileMachineBase.enableSecurity[var3] = var1.getBool();
        }
        TileDynamoBase.enableSecurity = var1.getBool();
        TileCell.enableSecurity = var1.getBool();
        TileStrongbox.enableSecurity = var1.getBool();
        TileWorkbench.enableSecurity = var1.getBool();
        ItemSatchel.enableSecurity = var1.getBool();
        log.info("Receiving Server Configuration...");
        TeleportChannelRegistry.createClientRegistry();
    }

    public PacketCoFHBase getConfigSync() {
        PacketCoFHBase var1 = PacketTEBase.getPacket(PacketTEBase.PacketTypes.CONFIG_SYNC);
        for (int var2 = 0; var2 < TileDeviceBase.enableSecurity.length; ++var2) {
            var1.addBool(TileDeviceBase.enableSecurity[var2]);
        }
        for (int var3 = 0; var3 < TileMachineBase.enableSecurity.length; ++var3) {
            var1.addBool(TileMachineBase.enableSecurity[var3]);
        }
        var1.addBool(TileDynamoBase.enableSecurity);
        var1.addBool(TileCell.enableSecurity);
        var1.addBool(TileStrongbox.enableSecurity);
        var1.addBool(TileWorkbench.enableSecurity);
        var1.addBool(ItemSatchel.enableSecurity);
        return var1;
    }

    public synchronized void handleIdMapping() {
        FurnaceManager.refreshRecipes();
        PulverizerManager.refreshRecipes();
        SawmillManager.refreshRecipes();
        SmelterManager.refreshRecipes();
        CrucibleManager.refreshRecipes();
        TransposerManager.refreshRecipes();
        PrecipitatorManager.refreshRecipes();
        ExtruderManager.refreshRecipes();
        ChargerManager.refreshRecipes();
        InsolatorManager.refreshRecipes();
        BlockDevice.refreshItemStacks();
        BlockDynamo.refreshItemStacks();
        BlockMachine.refreshItemStacks();
    }

    public void resetClientConfigs() {
        TileCell.configure();
        TileDeviceBase.configure();
        TileDynamoBase.configure();
        TileMachineBase.configure();
        TileWorkbench.configure();
        TileStrongbox.configure();
        ItemSatchel.configure();
        this.handleIdMapping();
        log.info(StringHelper.localize((String)"Restoring Client Configuration..."));
    }

    void registerMachineOreDict() {
        String var1 = "General";
        String var2 = "If enabled, ingots are used instead of gears in many default recipes.";
        String var3 = config.get(var1, "UseIngots", false, var2) ? "ingot" : "gear";
        for (String var5 : Arrays.asList("Iron", "Gold", "Copper", "Tin", "Silver", "Lead", "Nickel", "Platinum", "Mithril", "Electrum", "Invar", "Bronze", "Signalum", "Lumium", "Enderium")) {
            String var6 = "thermalexpansion:machine";
            for (ItemStack o : OreDictionary.getOres((String)(var3 + var5))) {
                OreDictionary.registerOre((String)(var6 + var5), (ItemStack)o);
            }
        }
    }

    void configOptions() {
        if (CoFHProps.enableColorBlindTextures) {
            TEProps.textureGuiCommon = TEProps.PATH_COMMON_CB;
            TEProps.textureGuiAssembler = TEProps.PATH_ASSEMBLER_CB;
            TEProps.textureSelection = "Config_CB_";
            BlockCell.textureSelection = "CellConfig_CB_";
        }
        TEProps.useAlternateStarfieldShader = configClient.get("Render", "UseAlternateShader", true, "Set to TRUE for Tesseracts to use an alternate starfield shader.");
        String var1 = "Interface.CreativeTab";
        boolean var3 = false;
        boolean var4 = false;
        boolean var5 = false;
        boolean var6 = false;
        String var2 = "Set to TRUE to put Thermal Expansion Blocks under a general \"Thermal Expansion\" Creative Tab.";
        var3 = configClient.get(var1, "BlocksInCommonTab", var3, var2);
        var2 = "Set to TRUE to put Thermal Expansion Items under a general \"Thermal Expansion\" Creative Tab.";
        var4 = configClient.get(var1, "ItemsInCommonTab", var4, var2);
        var2 = "Set to TRUE to put Thermal Expansion Tools under a general \"Thermal Expansion\" Creative Tab.";
        var5 = configClient.get(var1, "ToolsInCommonTab", var5, var2);
        var2 = "Set to TRUE to put Thermal Expansion Florbs under a general \"Thermal Expansion\" Creative Tab.";
        var6 = configClient.get(var1, "FlorbsInCommonTab", var6, var2);
        if (var3 || var4 || var5 || var6) {
            tabCommon = new TECreativeTab();
        }
        tabBlocks = var3 ? tabCommon : new TECreativeTab("Blocks"){};
        tabItems = var4 ? tabCommon : new TECreativeTab("Items"){

            @Override
            protected ItemStack getStack() {
                return TEItems.powerCoilElectrum;
            }
        };
        tabTools = var5 ? tabCommon : new TECreativeTab("Tools"){

            @Override
            protected ItemStack getStack() {
                return TEItems.toolWrench;
            }
        };
    }

    void cleanConfig(boolean var1) {
        String[] var3;
        String var2 = "config.thermalexpansion.";
        for (String value : var3 = config.getCategoryNames().toArray(new String[0])) {
            config.getCategory(value).setLanguageKey(var2 + value).setRequiresMcRestart(true);
        }
        for (String s : var3 = configClient.getCategoryNames().toArray(new String[0])) {
            configClient.getCategory(s).setLanguageKey(var2 + s).setRequiresMcRestart(true);
        }
    }

    @Mod.EventHandler
    public void missingMappings(FMLMissingMappingsEvent var1) {
        for (FMLMissingMappingsEvent.MissingMapping var4 : var1.get()) {
            String var5 = var4.name;
            if (var5.indexOf(58) >= 0) {
                var5 = var5.substring(var5.indexOf(58) + 1);
            }
            if (var4.type != GameRegistry.Type.ITEM || var5.indexOf("tool.") != 0 && var5.indexOf("armor.") != 0) continue;
            Item var6 = GameRegistry.findItem((String)"ThermalFoundation", (String)var5);
            if (var6 != null) {
                var4.remap(var6);
                continue;
            }
            var4.warn();
        }
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        log = LogManager.getLogger((String)modId);
        config = new ConfigHandler(version);
        configClient = new ConfigHandler(version);
        guiHandler = new GuiHandler();
        tabBlocks = tabCommon = null;
        tabItems = tabCommon;
        tabTools = tabCommon;
        tabFlorbs = tabCommon;
    }
}

