/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.tank;

import cofh.core.item.ItemBlockBase;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.tank.BlockTank;
import cofh.thermalexpansion.block.tank.TileTank;
import com.gamerforea.cofh.EventConfig;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemBlockTank
extends ItemBlockBase
implements IFluidContainerItem {
    public ItemBlockTank(Block var1) {
        super(var1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public int getItemStackLimit(ItemStack stack) {
        if (EventConfig.fixMaxStackSize) {
            return super.getItemStackLimit(stack);
        }
        return stack.field_77990_d != null && stack.field_77990_d.func_74764_b("Fluid") ? super.getItemStackLimit(stack) : 64;
    }

    public String func_77667_c(ItemStack var1) {
        return "tile.thermalexpansion.tank." + BlockTank.NAMES[ItemHelper.getItemDamage((ItemStack)var1)] + ".name";
    }

    public EnumRarity func_77613_e(ItemStack var1) {
        switch (BlockTank.Types.values()[ItemHelper.getItemDamage((ItemStack)var1)]) {
            case CREATIVE: {
                return EnumRarity.epic;
            }
            case RESONANT: {
                return EnumRarity.rare;
            }
            case REINFORCED: {
                return EnumRarity.uncommon;
            }
        }
        return EnumRarity.common;
    }

    public void func_77624_a(ItemStack var1, EntityPlayer var2, List var3, boolean var4) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            var3.add(StringHelper.shiftForDetails());
        }
        if (StringHelper.isShiftKeyDown()) {
            if (var1.field_77990_d != null && var1.field_77990_d.func_74764_b("Fluid")) {
                FluidStack var5 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)var1.field_77990_d.func_74775_l("Fluid"));
                if (var5 != null) {
                    String var6 = "\u00a77";
                    if (var5.getFluid().getRarity() == EnumRarity.uncommon) {
                        var6 = "\u00a7e";
                    } else if (var5.getFluid().getRarity() == EnumRarity.rare) {
                        var6 = "\u00a7b";
                    } else if (var5.getFluid().getRarity() == EnumRarity.epic) {
                        var6 = "\u00a7d";
                    }
                    var3.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + var6 + var5.getFluid().getLocalizedName(var5) + "\u00a77");
                    if (ItemHelper.getItemDamage((ItemStack)var1) == BlockTank.Types.CREATIVE.ordinal()) {
                        var3.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
                    } else {
                        var3.add(StringHelper.localize((String)"info.cofh.level") + ": " + var5.amount + " / " + TileTank.CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)] + " mB");
                    }
                } else {
                    var3.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
                    if (ItemHelper.getItemDamage((ItemStack)var1) == BlockTank.Types.CREATIVE.ordinal()) {
                        var3.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
                    } else {
                        var3.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + TileTank.CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)] + " mB");
                    }
                }
            } else {
                var3.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
                if (ItemHelper.getItemDamage((ItemStack)var1) == BlockTank.Types.CREATIVE.ordinal()) {
                    var3.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
                } else {
                    var3.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + TileTank.CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)] + " mB");
                }
            }
        }
    }

    public FluidStack getFluid(ItemStack var1) {
        return var1.field_77990_d != null && var1.field_77990_d.func_74764_b("Fluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)var1.field_77990_d.func_74775_l("Fluid")) : null;
    }

    public int getCapacity(ItemStack var1) {
        return TileTank.CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)];
    }

    public int fill(ItemStack var1, FluidStack var2, boolean var3) {
        if (var2 != null && var1.field_77994_a <= 1) {
            int var4 = this.getCapacity(var1);
            if (!var3) {
                if (var1.field_77990_d != null && var1.field_77990_d.func_74764_b("Fluid")) {
                    FluidStack var9 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)var1.field_77990_d.func_74775_l("Fluid"));
                    return var9 == null ? Math.min(var4, var2.amount) : (!var9.isFluidEqual(var2) ? 0 : Math.min(var4 - var9.amount, var2.amount));
                }
                return Math.min(var4, var2.amount);
            }
            if (var1.field_77990_d == null) {
                var1.field_77990_d = new NBTTagCompound();
            }
            if (!var1.field_77990_d.func_74764_b("Fluid")) {
                NBTTagCompound var8 = var2.writeToNBT(new NBTTagCompound());
                if (var4 < var2.amount) {
                    var8.func_74768_a("Amount", var4);
                    var1.field_77990_d.func_74782_a("Fluid", (NBTBase)var8);
                    return var4;
                }
                var8.func_74768_a("Amount", var2.amount);
                var1.field_77990_d.func_74782_a("Fluid", (NBTBase)var8);
                return var2.amount;
            }
            NBTTagCompound var5 = var1.field_77990_d.func_74775_l("Fluid");
            FluidStack var6 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)var5);
            if (!var6.isFluidEqual(var2)) {
                return 0;
            }
            int var7 = var4 - var6.amount;
            if (var2.amount < var7) {
                var6.amount += var2.amount;
                var7 = var2.amount;
            } else {
                var6.amount = var4;
            }
            var1.field_77990_d.func_74782_a("Fluid", (NBTBase)var6.writeToNBT(var5));
            return var7;
        }
        return 0;
    }

    public FluidStack drain(ItemStack var1, int var2, boolean var3) {
        if (var1.field_77990_d != null && var1.field_77990_d.func_74764_b("Fluid") && var2 != 0 && var1.field_77994_a <= 1) {
            FluidStack var4 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)var1.field_77990_d.func_74775_l("Fluid"));
            if (var4 == null) {
                return null;
            }
            int var5 = Math.min(var4.amount, var2);
            if (var3 && ItemHelper.getItemDamage((ItemStack)var1) != BlockTank.Types.CREATIVE.ordinal()) {
                if (var2 >= var4.amount) {
                    var1.field_77990_d.func_82580_o("Fluid");
                    if (var1.field_77990_d.func_82582_d()) {
                        var1.field_77990_d = null;
                    }
                    return var4;
                }
                NBTTagCompound var6 = var1.field_77990_d.func_74775_l("Fluid");
                var6.func_74768_a("Amount", var6.func_74762_e("Amount") - var5);
                var1.field_77990_d.func_74782_a("Fluid", (NBTBase)var6);
            }
            var4.amount = var5;
            return var4;
        }
        return null;
    }
}

