/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.block.IBlockDebug;
import cofh.api.block.IBlockInfo;
import cofh.api.block.IDismantleable;
import cofh.api.core.IInitializer;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.inventory.IInventoryRetainer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.api.tileentity.ITileInfo;
import cofh.core.block.TileCoFHBase;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.position.BlockPosition;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockCoFHBase
extends Block
implements ITileEntityProvider,
IBlockDebug,
IBlockInfo,
IDismantleable,
IInitializer {
    public static int renderPass = 0;
    public static final ArrayList<ItemStack> NO_DROP = new ArrayList();

    public BlockCoFHBase(Material material) {
        super(material);
        this.func_149672_a(Block.field_149769_e);
    }

    public TileEntity createTileEntity(World world, int n) {
        return this.func_149915_a(world, n);
    }

    public void func_149749_a(World world, int n, int n2, int n3, Block block, int n4) {
        TileCoFHBase tileCoFHBase;
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileCoFHBase) {
            tileCoFHBase = (TileCoFHBase)tileEntity;
            tileCoFHBase.blockBroken();
        }
        if (!(tileEntity instanceof IInventoryRetainer) && tileEntity instanceof IInventory) {
            tileCoFHBase = (IInventory)tileEntity;
            for (int i = 0; i < tileCoFHBase.func_70302_i_(); ++i) {
                CoreUtils.dropItemStackIntoWorldWithVelocity(tileCoFHBase.func_70301_a(i), world, n, n2, n3);
            }
        }
        if (tileEntity != null) {
            world.func_147475_p(n, n2, n3);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int n, int n2, int n3) {
        if (world.func_147439_a(n, n2, n3) != this) {
            return this.getStatelessBoundingBox(world, n, n2, n3);
        }
        return this.getBoundingBox(world, n, n2, n3);
    }

    protected AxisAlignedBB getBoundingBox(World world, int n, int n2, int n3) {
        this.func_149719_a((IBlockAccess)world, n, n2, n3);
        return super.func_149668_a(world, n, n2, n3);
    }

    protected AxisAlignedBB getStatelessBoundingBox(World world, int n, int n2, int n3) {
        return super.func_149668_a(world, n, n2, n3);
    }

    public void func_149636_a(World world, EntityPlayer entityPlayer, int n, int n2, int n3, int n4) {
    }

    public void func_149681_a(World world, int n, int n2, int n3, int n4, EntityPlayer entityPlayer) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, n, n2, n3, n4, 0);
            world.func_147465_d(n, n2, n3, Blocks.field_150350_a, 0, 7);
        }
    }

    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        Object object;
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (ServerHelper.isServerWorld(world) && tileEntity instanceof ISecurable && SecurityHelper.isSecure(itemStack)) {
            object = SecurityHelper.getOwner(itemStack);
            if (!((ISecurable)tileEntity).setOwner((GameProfile)object) && entityLivingBase instanceof ICommandSender) {
                ((ISecurable)tileEntity).setOwnerName(entityLivingBase.func_70005_c_());
            }
            ((ISecurable)tileEntity).setAccess(SecurityHelper.getAccess(itemStack));
        }
        if (tileEntity instanceof IRedstoneControl && RedstoneControlHelper.hasRSControl(itemStack)) {
            ((IRedstoneControl)tileEntity).setControl(RedstoneControlHelper.getControl(itemStack));
        }
        if (tileEntity instanceof IReconfigurableFacing) {
            object = (IReconfigurableFacing)tileEntity;
            int n4 = MathHelper.floor((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
            if (object.allowYAxisFacing()) {
                n4 = entityLivingBase.field_70125_A > 60.0f ? 4 : (entityLivingBase.field_70125_A < -60.0f ? 5 : n4);
            }
            switch (n4) {
                case 0: {
                    object.setFacing(2);
                    break;
                }
                case 1: {
                    object.setFacing(5);
                    break;
                }
                case 2: {
                    object.setFacing(3);
                    break;
                }
                case 3: {
                    object.setFacing(4);
                    break;
                }
                case 4: {
                    object.setFacing(1);
                    break;
                }
                case 5: {
                    object.setFacing(0);
                }
            }
        }
        if (tileEntity instanceof TileCoFHBase) {
            ((TileCoFHBase)tileEntity).onNeighborBlockChange();
            ((TileCoFHBase)tileEntity).blockPlaced();
        }
    }

    public void func_149695_a(World world, int n, int n2, int n3, Block block) {
        TileEntity tileEntity = BlockPosition.getTileEntityRaw(world, n, n2, n3);
        if (tileEntity instanceof TileCoFHBase) {
            ((TileCoFHBase)tileEntity).onNeighborBlockChange();
        }
    }

    public void onNeighborChange(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4, int n5, int n6) {
        TileEntity tileEntity = iBlockAccess instanceof World ? BlockPosition.getTileEntityRaw((World)iBlockAccess, n, n2, n3) : iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileCoFHBase) {
            ((TileCoFHBase)tileEntity).onNeighborTileChange(n4, n5, n6);
        }
    }

    public float func_149737_a(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof ISecurable && !((ISecurable)tileEntity).canPlayerAccess(entityPlayer)) {
            return -1.0f;
        }
        return ForgeHooks.blockStrength((Block)this, (EntityPlayer)entityPlayer, (World)world, (int)n, (int)n2, (int)n3);
    }

    public int func_149692_a(int n) {
        return n;
    }

    public int func_149736_g(World world, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        return tileEntity instanceof TileCoFHBase ? ((TileCoFHBase)tileEntity).getComparatorInput(n4) : 0;
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileCoFHBase && tileEntity.func_145831_w() != null) {
            return ((TileCoFHBase)tileEntity).getLightValue();
        }
        return 0;
    }

    public boolean canCreatureSpawn(EnumCreatureType enumCreatureType, IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149696_a(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        return tileEntity != null ? tileEntity.func_145842_c(n4, n5) : false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean rotateBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        return tileEntity instanceof IReconfigurableFacing ? ((IReconfigurableFacing)tileEntity).rotateBlock() : false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
    }

    public ArrayList<ItemStack> getDrops(World world, int n, int n2, int n3, int n4, int n5) {
        return this.dismantleBlock(null, this.getItemStackTag(world, n, n2, n3), world, n, n2, n3, false, true);
    }

    public ItemStack getPickBlock(MovingObjectPosition movingObjectPosition, World world, int n, int n2, int n3) {
        Item item = Item.func_150898_a((Block)this);
        if (item == null) {
            return null;
        }
        int n4 = world.func_72805_g(n, n2, n3);
        ItemStack itemStack = new ItemStack(item, 1, n4);
        itemStack.func_77982_d(this.getItemStackTag(world, n, n2, n3));
        return itemStack;
    }

    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        return null;
    }

    public abstract ArrayList<ItemStack> dismantleBlock(EntityPlayer var1, NBTTagCompound var2, World var3, int var4, int var5, int var6, boolean var7, boolean var8);

    @Override
    public void debugBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer) {
    }

    @Override
    public void getBlockInfo(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer, List<IChatComponent> list, boolean bl) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof ITileInfo) {
            ((ITileInfo)tileEntity).getTileInfo(list, forgeDirection, entityPlayer, bl);
        } else if (tileEntity instanceof IEnergyReceiver) {
            IEnergyReceiver iEnergyReceiver = (IEnergyReceiver)tileEntity;
            if (iEnergyReceiver.getMaxEnergyStored(forgeDirection) <= 0) {
                return;
            }
            list.add((IChatComponent)new ChatComponentText(StringHelper.localize("info.cofh.energy") + ": " + iEnergyReceiver.getEnergyStored(forgeDirection) + "/" + iEnergyReceiver.getMaxEnergyStored(forgeDirection) + " RF."));
        }
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        return this.dismantleBlock(entityPlayer, this.getItemStackTag(world, n, n2, n3), world, n, n2, n3, bl, false);
    }

    @Override
    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof ISecurable) {
            return ((ISecurable)tileEntity).canPlayerAccess(entityPlayer);
        }
        if (tileEntity instanceof TileCoFHBase) {
            return ((TileCoFHBase)tileEntity).canPlayerDismantle(entityPlayer);
        }
        return true;
    }

    @Override
    public boolean preInit() {
        return true;
    }
}

