/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.core.ProxyClient;
import cofh.core.render.customcharrendering.ICustomCharRenderer;
import cofh.core.render.customcharrendering.RenderPlayerFace;
import cofh.core.render.customcharrendering.RenderSprite;
import cofh.lib.util.helpers.SecurityHelper;
import com.google.common.base.Preconditions;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TCharObjectHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class CoFHFontRenderer
extends FontRenderer {
    private float r;
    private float g;
    private float b;
    private float a;
    public final TCharObjectHashMap<ICustomCharRenderer> renderOverrides = new TCharObjectHashMap();
    private char n = (char)888;
    private static final Field RENDER_ENGINE_FIELD;
    private static final boolean RENDER_ENGINE_FINAL;
    private final TextureManager cachedRenderEngine = RENDER_ENGINE_FINAL ? this.getDirectRenderEngine() : null;

    private TextureManager getRenderEngine() {
        return this.cachedRenderEngine == null ? this.getDirectRenderEngine() : this.cachedRenderEngine;
    }

    private TextureManager getDirectRenderEngine() {
        try {
            return (TextureManager)RENDER_ENGINE_FIELD.get((Object)this);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CoFHFontRenderer(GameSettings var1, ResourceLocation var2, TextureManager var3, boolean var4) {
        super(var1, var2, var3, var4);
    }

    public int func_78256_a(String var1) {
        if (var1 == null) {
            return 0;
        }
        int var2 = 0;
        boolean var3 = false;
        for (int var4 = 0; var4 < var1.length(); ++var4) {
            char var5 = var1.charAt(var4);
            int var6 = this.func_78263_a(var5);
            if (var6 < 0 && var4 < var1.length() - 1) {
                if ((var5 = var1.charAt(++var4)) != 'l' && var5 != 'L') {
                    if (var5 == 'r' || var5 == 'R') {
                        var3 = false;
                    }
                } else {
                    var3 = true;
                }
                var6 = 0;
            }
            var2 += var6;
            if (!var3) continue;
            ++var2;
        }
        return var2;
    }

    public String func_78269_a(String var1, int var2) {
        return this.func_78262_a(var1, var2, false);
    }

    public List<String> func_78271_c(String var1, int var2) {
        return Arrays.asList(this.func_78280_d(var1, var2).split("\n"));
    }

    public String func_78280_d(String var1, int var2) {
        int var3 = this.func_78259_e(var1, var2);
        if (var1.length() <= var3) {
            return var1;
        }
        String var4 = var1.substring(0, var3);
        char var5 = var1.charAt(var3);
        boolean var6 = var5 == ' ' || var5 == '\n';
        String var7 = CoFHFontRenderer.getFormatFromString(var4) + var1.substring(var3 + (var6 ? 1 : 0));
        return var4 + "\n" + this.func_78280_d(var7, var2);
    }

    public int func_78259_e(String var1, int var2) {
        int var5;
        int var3 = var1.length();
        int var4 = 0;
        int var6 = -1;
        boolean var7 = false;
        for (var5 = 0; var5 < var3; ++var5) {
            char var8 = var1.charAt(var5);
            switch (var8) {
                case '\n': {
                    --var5;
                    break;
                }
                case ' ': {
                    var6 = var5;
                }
                default: {
                    var4 += this.func_78263_a(var8);
                    if (!var7) break;
                    ++var4;
                    break;
                }
                case '\u00a7': {
                    char var9;
                    if (var5 >= var3 - 1) break;
                    if ((var9 = var1.charAt(++var5)) != 'l' && var9 != 'L') {
                        if (var9 != 'r' && var9 != 'R' && !CoFHFontRenderer.isFormatColor(var9)) break;
                        var7 = false;
                        break;
                    }
                    var7 = true;
                }
            }
            if (var8 == '\n') {
                var6 = ++var5;
                break;
            }
            if (var4 > var2) break;
        }
        return var5 != var3 && var6 != -1 && var6 < var5 ? var6 : var5;
    }

    public static String getFormatFromString(String var0) {
        String var1 = "";
        int var2 = -1;
        int var3 = var0.length();
        while ((var2 = var0.indexOf(167, var2 + 1)) != -1) {
            if (var2 >= var3 - 1) continue;
            char var4 = var0.charAt(var2 + 1);
            if (CoFHFontRenderer.isFormatColor(var4)) {
                var1 = "\u00a7" + var4;
                continue;
            }
            if (!CoFHFontRenderer.isFormatSpecial(var4)) continue;
            var1 = var1 + "\u00a7" + var4;
        }
        return var1;
    }

    public static boolean isFormatColor(char var0) {
        return var0 >= '0' && var0 <= '9' || var0 >= 'a' && var0 <= 'f' || var0 >= 'A' && var0 <= 'F';
    }

    public static boolean isFormatSpecial(char var0) {
        return var0 >= 'k' && var0 <= 'o' || var0 >= 'K' && var0 <= 'O' || var0 == 'r' || var0 == 'R';
    }

    public void resetColor() {
        super.setColor(this.r, this.g, this.b, this.a);
    }

    public void setColor(float var1, float var2, float var3, float var4) {
        this.r = var1;
        this.g = var2;
        this.b = var3;
        this.a = var4;
        super.setColor(var1, var2, var3, var4);
    }

    public float func_78277_a(char var1, boolean var2) {
        float var4;
        ICustomCharRenderer var3 = (ICustomCharRenderer)this.renderOverrides.get(var1);
        if (var3 != null && (var4 = var3.renderChar(var1, var2, this.field_78295_j, this.field_78296_k, this)) != -2.0f) {
            return var4;
        }
        return super.func_78277_a(var1, var2);
    }

    public int func_78263_a(char var1) {
        int var3;
        ICustomCharRenderer var2 = (ICustomCharRenderer)this.renderOverrides.get(var1);
        if (var2 != null && (var3 = var2.getCharWidth(var1, this)) != -2) {
            return var3;
        }
        return super.func_78263_a(var1);
    }

    public void initSpecialCharacters() {
        RenderSprite.addRenderer('\u2661', Gui.field_110324_m, 52, 0, 9, 9, this);
        RenderSprite.addRenderer('\u2665', Gui.field_110324_m, 124, 0, 9, 9, this);
        RenderSprite.addRenderer('\u2314', Gui.field_110324_m, 34, 9, 9, 9, this);
        RenderSprite.addRenderer('\u25cb', Gui.field_110324_m, 16, 18, 9, 9, this);
        RenderSprite.addRenderer('\u25cc', Gui.field_110324_m, 25, 18, 9, 9, this);
        RenderSprite.addRenderer('\u29f0', Gui.field_110324_m, 52, 27, 9, 9, this);
        RenderSprite.addRenderer('\u2763', Gui.field_110324_m, 52, 45, 9, 9, this);
        ResourceLocation var1 = new ResourceLocation("textures/gui/container/beacon.png");
        RenderSprite.addRenderer('\u2715', var1, 113, 222, 15, 15, this);
        RenderSprite.addRenderer('\u2714', var1, 90, 223, 16, 14, this);
        RenderPlayerFace.init(this);
    }

    public void bindTexture(ResourceLocation location) {
        TextureManager renderEngine = this.getRenderEngine();
        if (renderEngine == null) {
            super.bindTexture(location);
        } else {
            renderEngine.func_110577_a(location);
        }
    }

    public static FontRenderer loadFontRendererStack(ItemStack var0) {
        return SecurityHelper.isSecure(var0) ? RenderPlayerFace.loadProfile(var0) : ProxyClient.fontRenderer;
    }

    public char getNextBlankChar() {
        this.n = (char)(this.n + '\u0001');
        while (this.field_78287_e[this.n] != 0 && this.renderOverrides.containsKey(this.n)) {
            this.n = (char)(this.n + '\u0001');
        }
        return this.n;
    }

    static {
        boolean renderEngineFinal;
        Field renderEngineField;
        try {
            renderEngineField = ReflectionHelper.findField(FontRenderer.class, (String[])new String[]{"field_78298_i", "renderEngine"});
            renderEngineField.setAccessible(true);
            renderEngineFinal = Modifier.isFinal(renderEngineField.getModifiers());
            Preconditions.checkArgument((boolean)TextureManager.class.isAssignableFrom(renderEngineField.getType()), (Object)"FontRenderer#renderEngine must be assignable from TextureManager");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            renderEngineField = null;
            renderEngineFinal = false;
        }
        RENDER_ENGINE_FIELD = renderEngineField;
        RENDER_ENGINE_FINAL = renderEngineFinal;
    }
}

