/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.SpriteSheetManager;
import cofh.repack.codechicken.lib.render.TextureDataHolder;
import cofh.repack.codechicken.lib.render.TextureFX;
import cofh.repack.codechicken.lib.render.TextureUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureSpecial
extends TextureAtlasSprite
implements TextureUtils.IIconSelfRegister {
    private int spriteIndex;
    private SpriteSheetManager.SpriteSheet spriteSheet;
    private TextureFX textureFX;
    private int mipmapLevels;
    private int rawWidth;
    private int rawHeight;
    private int blankSize = -1;
    private ArrayList<TextureDataHolder> baseTextures;
    private boolean selfRegister;
    public int atlasIndex;

    protected TextureSpecial(String string) {
        super(string);
    }

    public TextureSpecial addTexture(TextureDataHolder textureDataHolder) {
        if (this.baseTextures == null) {
            this.baseTextures = new ArrayList();
        }
        this.baseTextures.add(textureDataHolder);
        return this;
    }

    public TextureSpecial baseFromSheet(SpriteSheetManager.SpriteSheet spriteSheet, int n) {
        this.spriteSheet = spriteSheet;
        this.spriteIndex = n;
        return this;
    }

    public TextureSpecial addTextureFX(TextureFX textureFX) {
        this.textureFX = textureFX;
        return this;
    }

    public void func_110971_a(int n, int n2, int n3, int n4, boolean bl) {
        super.func_110971_a(n, n2, n3, n4, bl);
        if (this.textureFX != null) {
            this.textureFX.onTextureDimensionsUpdate(this.rawWidth, this.rawHeight);
        }
    }

    public void func_94219_l() {
        if (this.textureFX != null) {
            this.textureFX.update();
            if (this.textureFX.changed()) {
                Object object = new int[this.mipmapLevels + 1][];
                object[0] = this.textureFX.imageData;
                object = this.prepareAnisotropicFiltering((int[][])object);
                object = TextureUtil.func_147949_a((int)this.mipmapLevels, (int)this.field_130223_c, (int[][])object);
                TextureUtil.func_147955_a((int[][])object, (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            }
        }
    }

    public int[][] prepareAnisotropicFiltering(int[][] nArray) {
        if (Minecraft.func_71410_x().field_71474_y.field_151443_J <= 1) {
            return nArray;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            if (nArray2 == null) continue;
            int[] nArray3 = new int[(this.rawWidth + 16 >> i) * (this.rawHeight + 16 >> i)];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            nArrayArray[i] = TextureUtil.func_147948_a((int[])nArray3, (int)(this.rawWidth >> i), (int)(this.rawHeight >> i), (int)(8 >> i));
        }
        return nArrayArray;
    }

    public void func_147964_a(BufferedImage[] bufferedImageArray, AnimationMetadataSection animationMetadataSection, boolean bl) {
        this.rawWidth = bufferedImageArray[0].getWidth();
        this.rawHeight = bufferedImageArray[0].getHeight();
        super.func_147964_a(bufferedImageArray, animationMetadataSection, bl);
    }

    public void func_147963_d(int n) {
        super.func_147963_d(n);
        this.mipmapLevels = n;
    }

    public boolean hasCustomLoader(IResourceManager iResourceManager, ResourceLocation resourceLocation) {
        return true;
    }

    public void addFrame(int[] nArray, int n, int n2) {
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        BufferedImage[] bufferedImageArray = new BufferedImage[gameSettings.field_151442_I + 1];
        bufferedImageArray[0] = new BufferedImage(n, n2, 2);
        bufferedImageArray[0].setRGB(0, 0, n, n2, nArray, 0, n);
        this.func_147964_a(bufferedImageArray, null, gameSettings.field_151443_J > 1);
    }

    public boolean load(IResourceManager iResourceManager, ResourceLocation resourceLocation) {
        if (this.baseTextures != null) {
            for (TextureDataHolder textureDataHolder : this.baseTextures) {
                this.addFrame(textureDataHolder.data, textureDataHolder.width, textureDataHolder.height);
            }
        } else if (this.spriteSheet != null) {
            TextureDataHolder textureDataHolder = this.spriteSheet.createSprite(this.spriteIndex);
            this.addFrame(textureDataHolder.data, textureDataHolder.width, textureDataHolder.height);
        } else if (this.blankSize > 0) {
            this.addFrame(new int[this.blankSize * this.blankSize], this.blankSize, this.blankSize);
        }
        if (this.field_110976_a.isEmpty()) {
            throw new RuntimeException("No base frame for texture: " + this.func_94215_i());
        }
        return false;
    }

    public boolean func_130098_m() {
        return this.textureFX != null || super.func_130098_m();
    }

    public int func_110970_k() {
        if (this.textureFX != null) {
            return 1;
        }
        return super.func_110970_k();
    }

    public TextureSpecial blank(int n) {
        this.blankSize = n;
        return this;
    }

    public TextureSpecial selfRegister() {
        this.selfRegister = true;
        TextureUtils.addIconRegistrar(this);
        return this;
    }

    @Override
    public void registerIcons(IIconRegister iIconRegister) {
        if (this.selfRegister) {
            ((TextureMap)iIconRegister).setTextureEntry(this.func_94215_i(), (TextureAtlasSprite)this);
        }
    }

    @Override
    public int atlasIndex() {
        return this.atlasIndex;
    }
}

