/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments;

import cofh.api.tileentity.IPortableData;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.attachments.IStuffable;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.filter.IFilterAttachment;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.IFilterItems;
import cofh.thermaldynamics.gui.client.GuiDuctConnection;
import cofh.thermaldynamics.gui.container.ContainerDuctConnection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class ConnectionBase
extends Attachment
implements IStuffable,
IRedstoneControl,
IFilterAttachment,
IPortableData {
    public boolean stuffed = false;
    public int type = 0;
    public boolean isValidInput;
    public boolean isPowered = false;
    public IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.HIGH;
    public FilterLogic filter;
    int prevFlag = -1;

    public ConnectionBase(TileTDBase var1, byte var2) {
        super(var1, var2);
    }

    public ConnectionBase(TileTDBase var1, byte var2, int var3) {
        this(var1, var2);
        this.type = var3;
        this.filter = this.createFilterLogic();
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74774_a("type", (byte)this.type);
        if (this.filter == null) {
            this.filter = this.createFilterLogic();
        }
        this.filter.writeToNBT(var1);
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        this.type = var1.func_74771_c("type") % 5;
        this.filter = this.createFilterLogic();
        this.filter.readFromNBT(var1);
    }

    @Override
    public TileTDBase.NeighborTypes getNeighborType() {
        return this.isValidInput ? TileTDBase.NeighborTypes.INPUT : TileTDBase.NeighborTypes.DUCT_ATTACHMENT;
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> var1 = new LinkedList<ItemStack>();
        var1.add(this.getPickBlock());
        return var1;
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase var1) {
        var1.addBool(this.stuffed);
        var1.addByte(this.type);
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase var1) {
        this.stuffed = var1.getBool();
        this.type = var1.getByte();
    }

    @Override
    public void onNeighborChange() {
        super.onNeighborChange();
        TileEntity var1 = this.tile.getAdjTileEntitySafe(this.side);
        this.clearCache();
        boolean var2 = this.isValidInput;
        this.isValidInput = this.isValidTile(var1);
        if (this.isValidInput) {
            this.cacheTile(var1);
        }
        boolean var3 = this.isPowered;
        boolean bl = this.isPowered = this.rsMode.isDisabled() || this.rsMode.getState() == this.getPowerState();
        if (var3 != this.isPowered || this.isValidInput != var2) {
            this.tile.func_145831_w().func_147471_g(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
        }
    }

    @Override
    public void checkSignal() {
        boolean var1 = this.isPowered;
        boolean bl = this.isPowered = this.rsMode.isDisabled() || this.rsMode.getState() == this.getPowerState();
        if (var1 != this.isPowered) {
            this.tile.func_145831_w().func_147471_g(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
        }
    }

    @Override
    public boolean respondsToSignallum() {
        return true;
    }

    public boolean getPowerState() {
        return this.tile.myGrid != null && this.tile.myGrid.rs != null && this.tile.myGrid.rs.redstoneLevel > 0 || this.tile.func_145831_w().func_72864_z(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
    }

    @Override
    public boolean isStuffed() {
        return false;
    }

    public abstract void clearCache();

    public abstract void cacheTile(TileEntity var1);

    public abstract boolean isValidTile(TileEntity var1);

    @Override
    public Cuboid6 getCuboid() {
        return TileTDBase.subSelection[this.side].copy();
    }

    @Override
    public boolean isNode() {
        return true;
    }

    public PacketTileInfo getNewPacket(byte var1) {
        PacketTileInfo var2 = this.getNewPacket();
        var2.addByte(var1);
        return var2;
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase var1, boolean var2, EntityPlayer var3) {
        super.handleInfoPacket(var1, var2, var3);
        byte var4 = var1.getByte();
        this.handleInfoPacketType(var4, var1, var2, var3);
    }

    public void setControl(IRedstoneControl.ControlMode var1) {
        if (this.canAlterRS()) {
            this.rsMode = var1;
            if (ServerHelper.isClientWorld((World)this.tile.world())) {
                PacketTileInfo var2 = this.getNewPacket((byte)1);
                var2.addByte(this.rsMode.ordinal());
                PacketHandler.sendToServer((PacketBase)var2);
            } else {
                this.onNeighborChange();
            }
        }
    }

    public IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }

    public void setPowered(boolean var1) {
        this.isPowered = var1;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean canAlterRS() {
        return false;
    }

    public FilterLogic getFilter() {
        if (this.filter == null) {
            this.filter = this.createFilterLogic();
        }
        return this.filter;
    }

    public void handleInfoPacketType(byte var1, PacketCoFHBase var2, boolean var3, EntityPlayer var4) {
        if (var1 == 1) {
            if (this.canAlterRS()) {
                this.setControl(IRedstoneControl.ControlMode.values()[var2.getByte()]);
            }
        } else if (var1 == 2) {
            byte var5;
            this.filter.setFlag(var5 >> 1, ((var5 = var2.getByte()) & 1) == 1);
            this.filter.recalc = true;
        } else if (var1 == 3) {
            byte var7 = var2.getByte();
            short var6 = var2.getShort();
            this.filter.setLevel(var7, var6);
            this.filter.recalc = true;
        }
    }

    public void sendFilterConfigPacketFlag(int var1, boolean var2) {
        PacketTileInfo var3 = this.getNewPacket((byte)2);
        var3.addByte(var1 << 1 | (var2 ? 1 : 0));
        PacketHandler.sendToServer((PacketBase)var3);
    }

    public void sendFilterConfigPacketLevel(int var1, int var2) {
        PacketTileInfo var3 = this.getNewPacket((byte)3);
        var3.addByte(var1);
        var3.addShort(var2);
        PacketHandler.sendToServer((PacketBase)var3);
    }

    @Override
    public void sendGuiNetworkData(Container var1, List var2, boolean var3) {
        super.sendGuiNetworkData(var1, var2, var3);
        int var4 = this.filter.getFlagByte();
        if (var4 != this.prevFlag || var3) {
            for (Object var6 : var2) {
                ((ICrafting)var6).func_71112_a(var1, 0, var4);
            }
        }
        this.prevFlag = var4;
        if (this.filter.levelsChanged || var3) {
            for (int var8 = 0; var8 < FilterLogic.defaultLevels.length; ++var8) {
                for (Object var7 : var2) {
                    ((ICrafting)var7).func_71112_a(var1, 1 + var8, this.filter.getLevel(var8));
                }
            }
            this.filter.levelsChanged = false;
        }
    }

    @Override
    public void receiveGuiNetworkData(int var1, int var2) {
        super.receiveGuiNetworkData(var1, var2);
        if (var1 == 0) {
            this.filter.handleFlagByte(var2);
        } else {
            this.filter.setLevel(var1 - 1, var2, false);
        }
    }

    @Override
    public Object getGuiServer(InventoryPlayer var1) {
        return new ContainerDuctConnection(var1, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiClient(InventoryPlayer var1) {
        return new GuiDuctConnection(var1, this);
    }

    @Override
    public void stuffItem(ItemStack var1) {
    }

    @Override
    public boolean canStuff() {
        return false;
    }

    @Override
    public BlockDuct.ConnectionTypes getRenderConnectionType() {
        return BlockDuct.ConnectionTypes.DUCT;
    }

    @Override
    public IFilterItems getItemFilter() {
        return this.filter;
    }

    @Override
    public IFilterFluid getFluidFilter() {
        return this.filter;
    }

    public abstract FilterLogic createFilterLogic();

    @Override
    public boolean openGui(EntityPlayer var1) {
        if (ServerHelper.isServerWorld((World)this.tile.world())) {
            var1.openGui((Object)ThermalDynamics.instance, 1 + this.side, this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
        }
        return true;
    }

    public String getDataType() {
        return "ConnectionBase";
    }

    public void readPortableData(EntityPlayer var1, NBTTagCompound var2) {
        if (this.canAlterRS() && var2.func_74764_b("RSControl")) {
            this.setControl(RedstoneControlHelper.getControlFromNBT((NBTTagCompound)var2));
        }
        this.filter.readFromNBT(var2);
        this.onNeighborChange();
    }

    public void writePortableData(EntityPlayer var1, NBTTagCompound var2) {
        if (this.canAlterRS()) {
            RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)var2, (IRedstoneControl)this);
        }
        if (this.filter == null) {
            this.filter = this.createFilterLogic();
        }
        this.filter.writeToNBT(var2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.ITransformer[] getHollowMask() {
        return CoverHoleRender.hollowDuctTile;
    }

    public static class NETWORK_ID {
        public static final byte GUI = 0;
        public static final byte RSCONTROL = 1;
        public static final byte FILTERFLAG = 2;
        public static final byte FILTERLEVEL = 3;
    }
}

