/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.api.tileentity.ISecurable;
import cofh.core.CoFHProps;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.util.Utils;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class TileInventory
extends TileTEBase
implements IInventory,
ISecurable {
    protected GameProfile owner = CoFHProps.DEFAULT_OWNER;
    protected ISecurable.AccessMode access = ISecurable.AccessMode.PUBLIC;
    protected boolean canAccess = true;
    protected boolean inWorld = false;
    public ItemStack[] inventory = new ItemStack[0];

    public void cofh_validate() {
        this.inWorld = true;
    }

    public void cofh_invalidate() {
        this.inWorld = false;
    }

    public boolean canAccess() {
        return this.canAccess;
    }

    public boolean isSecured() {
        return !SecurityHelper.isDefaultUUID((UUID)this.owner.getId());
    }

    public boolean enableSecurity() {
        return true;
    }

    public boolean extractItem(int var1, int var2, int var3) {
        block17: {
            TileEntity var6;
            if (var1 > this.inventory.length) break block17;
            ItemStack var4 = this.inventory[var1];
            if (var4 != null) {
                var2 = Math.min(var2, var4.func_77976_d() - var4.field_77994_a);
                var4 = this.inventory[var1].func_77946_l();
            }
            if (Utils.isAccessibleInput(var6 = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)var3), var3)) {
                if (var6 instanceof ISidedInventory) {
                    ISidedInventory var12 = (ISidedInventory)var6;
                    int[] var13 = var12.func_94128_d((int)BlockHelper.SIDE_OPPOSITE[var3]);
                    if (var13 == null) {
                        return false;
                    }
                    for (int var14 = 0; var14 < var13.length && var2 > 0; ++var14) {
                        ItemStack var16 = var12.func_70301_a(var13[var14]);
                        if (var16 == null || !var12.func_102008_b(var13[var14], var16, var3 ^ 1)) continue;
                        if (var4 == null) {
                            if (!this.func_94041_b(var1, var16)) continue;
                            int var11 = Math.min(var2, var16.field_77994_a);
                            var4 = ItemHelper.cloneStack((ItemStack)var16, (int)var11);
                            var16.field_77994_a -= var11;
                            if (var16.field_77994_a <= 0) {
                                var12.func_70299_a(var13[var14], (ItemStack)null);
                            } else {
                                var12.func_70299_a(var13[var14], var16);
                            }
                            var2 -= var11;
                            continue;
                        }
                        if (!ItemHelper.itemsEqualWithMetadata((ItemStack)var4, (ItemStack)var16, (boolean)true)) continue;
                        int var17 = Math.min(var4.func_77976_d() - var4.field_77994_a, Math.min(var2, var16.field_77994_a));
                        var4.field_77994_a += var17;
                        var16.field_77994_a -= var17;
                        if (var16.field_77994_a <= 0) {
                            var12.func_70299_a(var13[var14], (ItemStack)null);
                        } else {
                            var12.func_70299_a(var13[var14], var16);
                        }
                        var2 -= var17;
                    }
                } else {
                    IInventory var7 = (IInventory)var6;
                    for (int var8 = 0; var8 < var7.func_70302_i_() && var2 > 0; ++var8) {
                        ItemStack var9 = var7.func_70301_a(var8);
                        if (var9 == null) continue;
                        if (var4 == null) {
                            if (!this.func_94041_b(var1, var9)) continue;
                            int var10 = Math.min(var2, var9.field_77994_a);
                            var4 = ItemHelper.cloneStack((ItemStack)var9, (int)var10);
                            var9.field_77994_a -= var10;
                            if (var9.field_77994_a <= 0) {
                                var7.func_70299_a(var8, (ItemStack)null);
                            } else {
                                var7.func_70299_a(var8, var9);
                            }
                            var2 -= var10;
                            continue;
                        }
                        if (!ItemHelper.itemsEqualWithMetadata((ItemStack)var4, (ItemStack)var9, (boolean)true)) continue;
                        int var15 = Math.min(var4.func_77976_d() - var4.field_77994_a, Math.min(var2, var9.field_77994_a));
                        var4.field_77994_a += var15;
                        var9.field_77994_a -= var15;
                        if (var9.field_77994_a <= 0) {
                            var7.func_70299_a(var8, (ItemStack)null);
                        } else {
                            var7.func_70299_a(var8, var9);
                        }
                        var2 -= var15;
                    }
                }
            }
        }
        return false;
    }

    public boolean transferItem(int var1, int var2, int var3) {
        if (this.inventory[var1] != null) {
            ItemStack var4 = this.inventory[var1].func_77946_l();
            var4.field_77994_a = var2 = Math.min(var2, var4.field_77994_a);
            TileEntity var6 = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)var3);
            if (Utils.isAccessibleOutput(var6, var3)) {
                int var5 = Utils.addToInsertion(var6, var3, var4);
                if (var5 >= var2) {
                    return false;
                }
                this.inventory[var1].field_77994_a -= var2 - var5;
                if (this.inventory[var1].field_77994_a <= 0) {
                    this.inventory[var1] = null;
                }
                return true;
            }
            if (Utils.isPipeTile(var6)) {
                int var5 = Utils.addToPipeTile(var6, var3, var4);
                if (var5 <= 0) {
                    return false;
                }
                this.inventory[var1].field_77994_a -= var5;
                if (this.inventory[var1].field_77994_a <= 0) {
                    this.inventory[var1] = null;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int getInvSlotCount() {
        return this.inventory.length;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean openGui(EntityPlayer var1) {
        if (this.canPlayerAccess(var1)) {
            if (this.hasGui()) {
                var1.openGui((Object)ThermalExpansion.instance, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return this.hasGui();
        }
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            var1.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.cofh.secure", new Object[]{this.getOwnerName()}));
        }
        return false;
    }

    public void receiveGuiNetworkData(int var1, int var2) {
        this.canAccess = var2 != 0;
    }

    @Override
    public void sendGuiNetworkData(Container var1, ICrafting var2) {
        super.sendGuiNetworkData(var1, var2);
        var2.func_71112_a(var1, 0, this.canPlayerAccess((EntityPlayer)var2) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.owner = CoFHProps.DEFAULT_OWNER;
        this.access = ISecurable.AccessMode.modes[var1.func_74771_c("Access")];
        String var2 = var1.func_74779_i("OwnerUUID");
        String var3 = var1.func_74779_i("Owner");
        if (!Strings.isNullOrEmpty((String)var2)) {
            this.setOwner(new GameProfile(UUID.fromString(var2), var3));
        } else {
            this.setOwnerName(var3);
        }
        if (!this.enableSecurity()) {
            this.access = ISecurable.AccessMode.PUBLIC;
        }
        this.readInventoryFromNBT(var1);
    }

    @Override
    public void func_145841_b(NBTTagCompound var1) {
        super.func_145841_b(var1);
        var1.func_74774_a("Access", (byte)this.access.ordinal());
        var1.func_74778_a("OwnerUUID", this.owner.getId().toString());
        var1.func_74778_a("Owner", this.owner.getName());
        this.writeInventoryToNBT(var1);
    }

    public void readInventoryFromNBT(NBTTagCompound var1) {
        NBTTagList var2 = var1.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.inventory.length];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74762_e("Slot");
            if (var5 < 0 || var5 >= this.inventory.length) continue;
            this.inventory[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void writeInventoryToNBT(NBTTagCompound var1) {
        if (this.inventory.length > 0) {
            NBTTagList var2 = new NBTTagList();
            for (int var3 = 0; var3 < this.inventory.length; ++var3) {
                if (this.inventory[var3] == null) continue;
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74768_a("Slot", var3);
                this.inventory[var3].func_77955_b(var4);
                var2.func_74742_a((NBTBase)var4);
            }
            if (var2.func_74745_c() > 0) {
                var1.func_74782_a("Inventory", (NBTBase)var2);
            }
        }
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase var1 = super.getPacket();
        var1.addByte((byte)this.access.ordinal());
        var1.addUUID(this.owner.getId());
        var1.addString(this.owner.getName());
        return var1;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase var1, boolean var2) {
        super.handleTilePacket(var1, var2);
        this.access = ISecurable.AccessMode.modes[var1.getByte()];
        if (!var2) {
            this.owner = CoFHProps.DEFAULT_OWNER;
            this.setOwner(new GameProfile(var1.getUUID(), var1.getString()));
        } else {
            var1.getUUID();
            var1.getString();
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.inventory[var1] == null) {
            return null;
        }
        if (this.inventory[var1].field_77994_a <= var2) {
            var2 = this.inventory[var1].field_77994_a;
        }
        ItemStack var3 = this.inventory[var1].func_77979_a(var2);
        if (this.inventory[var1].field_77994_a <= 0) {
            this.inventory[var1] = null;
        }
        return var3;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.inventory[var1] == null) {
            return null;
        }
        ItemStack var2 = this.inventory[var1];
        this.inventory[var1] = null;
        return var2;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inventory[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
        if (this.inWorld) {
            this.markChunkDirty();
        }
    }

    public String func_145825_b() {
        return this.tileName.isEmpty() ? this.getName() : this.tileName;
    }

    public boolean func_145818_k_() {
        return !this.tileName.isEmpty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isUseable(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public boolean setAccess(ISecurable.AccessMode var1) {
        this.access = var1;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    public boolean setOwnerName(String var1) {
        if (MinecraftServer.func_71276_C() == null) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)var1) && !CoFHProps.DEFAULT_OWNER.getName().equalsIgnoreCase(var1)) {
            String var2 = PreYggdrasilConverter.func_152719_a((String)var1);
            return !Strings.isNullOrEmpty((String)var2) && this.setOwner(new GameProfile(UUID.fromString(var2), var1));
        }
        return false;
    }

    public boolean setOwner(GameProfile var1) {
        if (SecurityHelper.isDefaultUUID((UUID)this.owner.getId())) {
            this.owner = var1;
            if (!SecurityHelper.isDefaultUUID((UUID)this.owner.getId())) {
                if (MinecraftServer.func_71276_C() != null) {
                    new Thread("CoFH User Loader"){

                        @Override
                        public void run() {
                            TileInventory.this.owner = SecurityHelper.getProfile((UUID)TileInventory.this.owner.getId(), (String)TileInventory.this.owner.getName());
                        }
                    }.start();
                }
                if (this.inWorld) {
                    this.markChunkDirty();
                }
                return true;
            }
        }
        return false;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        String var1 = this.owner.getName();
        return var1 == null ? StringHelper.localize((String)"info.cofh.anotherplayer") : var1;
    }
}

