/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.network;

import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.lib.gui.container.IAugmentableContainer;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.gui.container.ISchematicContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketTEBase
extends PacketCoFHBase {
    public static void initialize() {
        PacketHandler.instance.registerPacket(PacketTEBase.class);
    }

    public void handlePacket(EntityPlayer player, boolean isServer) {
        try {
            byte packetType = this.getByte();
            switch (PacketTypes.values()[packetType]) {
                case RS_POWER_UPDATE: {
                    int[] coords = this.getCoords();
                    boolean powered = this.getBool();
                    if (!player.field_70170_p.func_72899_e(coords[0], coords[1], coords[2])) {
                        return;
                    }
                    IRedstoneControl tile = (IRedstoneControl)player.field_70170_p.func_147438_o(coords[0], coords[1], coords[2]);
                    if (tile == null) {
                        return;
                    }
                    tile.setPowered(powered);
                    return;
                }
                case RS_CONFIG_UPDATE: {
                    int[] coords = this.getCoords();
                    byte controlMode = this.getByte();
                    if (!player.field_70170_p.func_72899_e(coords[0], coords[1], coords[2])) {
                        return;
                    }
                    TileEntity tile = player.field_70170_p.func_147438_o(coords[0], coords[1], coords[2]);
                    IRedstoneControl redstoneControl = (IRedstoneControl)tile;
                    if (redstoneControl == null) {
                        return;
                    }
                    redstoneControl.setControl(IRedstoneControl.ControlMode.values()[controlMode]);
                    return;
                }
                case SECURITY_UPDATE: {
                    if (player.field_71070_bA instanceof ISecurable) {
                        ((ISecurable)player.field_71070_bA).setAccess(ISecurable.AccessMode.values()[this.getByte()]);
                    }
                    return;
                }
                case TAB_AUGMENT: {
                    if (player.field_71070_bA instanceof IAugmentableContainer) {
                        ((IAugmentableContainer)player.field_71070_bA).setAugmentLock(this.getBool());
                    }
                    return;
                }
                case TAB_SCHEMATIC: {
                    if (player.field_71070_bA instanceof ISchematicContainer) {
                        ((ISchematicContainer)player.field_71070_bA).writeSchematic();
                    }
                    return;
                }
                case CONFIG_SYNC: {
                    ThermalExpansion.instance.handleConfigSync(this);
                    return;
                }
            }
            ThermalExpansion.log.error("Unknown Packet! Internal: TEPH, ID: " + packetType);
        }
        catch (Exception var6) {
            ThermalExpansion.log.error("Packet payload failure! Please check your config files!");
            var6.printStackTrace();
        }
    }

    public static void sendRSPowerUpdatePacketToClients(IRedstoneControl var0, World var1, int var2, int var3, int var4) {
        PacketHandler.sendToAllAround((PacketBase)PacketTEBase.getPacket(PacketTypes.RS_POWER_UPDATE).addCoords(var2, var3, var4).addBool(var0.isPowered()), (World)var1, (int)var2, (int)var3, (int)var4);
    }

    public static void sendRSConfigUpdatePacketToServer(IRedstoneControl var0, int var1, int var2, int var3) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.RS_CONFIG_UPDATE).addCoords(var1, var2, var3).addByte(var0.getControl().ordinal()));
    }

    public static void sendSecurityPacketToServer(ISecurable var0) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.SECURITY_UPDATE).addByte(var0.getAccess().ordinal()));
    }

    public static void sendTabAugmentPacketToServer(boolean var0) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.TAB_AUGMENT).addBool(var0));
    }

    public static void sendTabSchematicPacketToServer() {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.TAB_SCHEMATIC));
    }

    public static void sendConfigSyncPacketToClient(EntityPlayer var0) {
        PacketHandler.sendTo((PacketBase)ThermalExpansion.instance.getConfigSync(), (EntityPlayer)var0);
    }

    public static PacketCoFHBase getPacket(PacketTypes var0) {
        return new PacketTEBase().addByte(var0.ordinal());
    }

    public static enum PacketTypes {
        RS_POWER_UPDATE,
        RS_CONFIG_UPDATE,
        SECURITY_UPDATE,
        TAB_AUGMENT,
        TAB_SCHEMATIC,
        CONFIG_SYNC;

    }
}

